import { expect } from 'chai';
import { describe } from 'mocha';
import { deployContractsForTests, getSigners } from './helpers/deploy-helper';
import { Signers } from './types';
import { DataAccessSubscription } from '../../types';

describe('50 - Data Access Subscription ERC1155 Contract Test', function () {
  let contract: DataAccessSubscription;
  let signers: Signers;
  beforeEach(async function () {
    contract = (await deployContractsForTests()).dataAccessSubscriptionContract;
    signers = await getSigners();
  });

  describe('Basic ERC 1155 tests:', function () {
    it('contract can be deployed', async function () {
      await expect(contract).to.exist;
    });
    it('token should have name Subscription', async function () {
      await expect(await contract.name()).is.equal('Subscription');
    });

    it('token should have SUBS symbol', async function () {
      await expect(await contract.symbol()).is.equal('SUBS');
    });
  });

  describe('URI functionality', function () {
    it('should have initial URI', async function () {
      expect(await contract.uri(0)).to.equal('');
    });

    it('owner can set new URI', async function () {
      const newURI = 'https://newuri.com';
      await contract.setURI(newURI);
      expect(await contract.uri(0)).to.equal(newURI);
    });

    it('only owner can set new URI', async function () {
      const newURI = 'https://newuri.com';
      await expect(
        contract.connect(signers.signer1).setURI(newURI),
      ).to.be.revertedWith('Ownable: caller is not the owner');
    });
  });

  describe('contract extends OpenZeppelin Ownable ', function () {
    it('should check contract owner', async function () {
      expect(await contract.owner()).to.equal(signers.admin.address);
    });
    it('owner can change the owner', async function () {
      await contract.transferOwnership(signers.signer1.address);
      expect(await contract.owner()).to.equal(signers.signer1.address);
    });
  });
});
